// ConfigureAreaAccess.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "ConfigureAreaAccess.h"
#define MAXLEN 255

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigureAreaAccess dialog


CConfigureAreaAccess::CConfigureAreaAccess(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigureAreaAccess::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigureAreaAccess)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

CConfigureAreaAccess ::CConfigureAreaAccess(IApplication *pApp):CDialog(CConfigureAreaAccess::IDD, NULL)
{
	pApplication = pApp;
}
void CConfigureAreaAccess::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigureAreaAccess)
	DDX_Control(pDX, IDC_READER_TZS, m_Readers_TZ);
	DDX_Control(pDX, IDC_READERS, m_ReadersList);
	DDX_Control(pDX, IDC_AVAIL_TZ, m_Timezones);
	DDX_Control(pDX, IDC_AREALIST, m_AreaList);
	DDX_Control(pDX, IDC_ACCTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_ACCLLIST, m_AcclList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigureAreaAccess, CDialog)
	//{{AFX_MSG_MAP(CConfigureAreaAccess)
	ON_CBN_SELCHANGE(IDC_ACCTLIST, OnSelchangeAcctlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAcctlist)
	ON_CBN_SELCHANGE(IDC_AREALIST, OnSelchangeArealist)
	ON_BN_CLICKED(ID_CONF_AREA, OnConfArea)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigureAreaAccess message handlers
BOOL CConfigureAreaAccess::OnInitDialog() 
{
	CDialog::OnInitDialog();

	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
              // EXCEPTION: OCX Property Pages should return FALSE

}

void CConfigureAreaAccess::LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_AcctList.SetCurSel(0);
}
void CConfigureAreaAccess::LoadSubAccounts(long lAcctID)
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
		pApplication->GetSubAccountsByAccountID(lAcctID,&vSubAccounts); // get subaccount details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pSubAccount = NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount != NULL)
			{
				m_SubAcctList.AddString(pSubAccount->AccountName);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_SubAcctList.SetCurSel(0);
}
void CConfigureAreaAccess ::LoadAccessLevels()
{
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//select subaccount name 
		int subacct_index = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(subacct_index,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();

		_variant_t vAccls;
		vAccls.Clear();
		pApplication->GetAccessLevelsByAccountName(bstrAcctName,bstrSubAcctName,&vAccls); // get access levels details of particular account  in WP-CS database server
		
		if(vAccls.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccessLevel *pAccl = NULL;
		
		COleSafeArray sa(vAccls);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccessLevel,(void**)&pAccl);
			if (pAccl != NULL)
			{
				m_AcclList.AddString(pAccl->AccessLevelName);
				pAccl->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcclList.SetCurSel(0);
}
void CConfigureAreaAccess::LoadReaders()
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	BSTR bstrAcclName;
	int index_Accl = m_AcclList.GetCurSel();
	CString sAcclName;
	if (index_Accl <0)
		bstrAcclName = SysAllocString(L"");
	else
	{
		m_AcclList.GetLBText(index_Accl,sAcclName);
		bstrAcclName = sAcclName.AllocSysString();
	}
	// This Name for get all readers configured in Access area
	//Because then only we configure the access  level for selected reader in access area

	//select branch name 
	BSTR bstrBranch;
	int index_Branch = m_AreaList.GetCurSel();
	CString sBranchName;
	if (index_Branch <0)
		bstrBranch = SysAllocString(L"");	
	else
	{
		 m_AreaList.GetLBText(index_Branch,sBranchName);
		 bstrBranch = sBranchName.AllocSysString();
	}
	_variant_t vReaders;
	vReaders.Clear();
	//to get all readers in Access area
	pApplication->GetReadersInAccessAreaBranch(bstrAcctName,bstrBranch,&vReaders);
		
	if(vReaders.vt == VT_EMPTY)
	{
		AfxMessageBox(L"No Readers");
		return;
	}
	
	long uBound =0 ;
	CString sReader_Tz;
	
	COleSafeArray sa(vReaders);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	BSTR bstrReader;
	for(long i =0 ;i <= uBound ; i++)
	{
		CString sTZname;
		sa.GetElement(&i,(void*)&bstrReader);
		CString sReader = CString(bstrReader);
		// For loading Associated Timezones -- Guru
		_variant_t vTz;
		vTz.Clear();
		pApplication->GetAssociatedTimeZoneOfReader(bstrAcclName,bstrAcctName,bstrReader,&vTz);
		if(vTz.vt ==  VT_EMPTY)
		{
			sTZname = _T("None");
		}
		UpdateData(TRUE);
		if( vTz.vt & VT_DISPATCH)
		{
			ITimeZonePtr pTz(vTz.pdispVal);

			//m_Exist_Tz =CString(((LPWSTR)pTz->TimeZoneName));

			sTZname = (LPCSTR) pTz->TimeZoneName;
			
		}
		sReader_Tz = sReader + _T(" : ")+ sTZname;
		m_Readers_TZ.AddString(sReader_Tz);
		if(NULL != vTz.pdispVal)
		{
			//vTz.pdispVal->Release();
			vTz.Clear();
		}
		m_ReadersList.AddString(sReader);
	}
}
void CConfigureAreaAccess :: LoadBranchList()
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);
	
	_variant_t vbranches;
	vbranches.Clear();
	pApplication->GetAccessAreaBranchesByAccountName (bstrAcctName,&vbranches);

	if(vbranches.vt == VT_EMPTY)
		{
			AfxMessageBox(L"No Branches");
			return;
		}
		
		long uBound =0 ;
		
		COleSafeArray sa(vbranches);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		BSTR bstrBranch;
		for(long i =0 ;i <= uBound ; i++)
		{
			sa.GetElement(&i,(void*)&bstrBranch);
			CString sBranch = CString(bstrBranch);
			//AfxMessageBox(Lscard);
			m_AreaList.AddString(sBranch);
		}
	
}
void CConfigureAreaAccess ::LoadAvailBranchTZs()
{
	//select account name 
	int index = m_AcctList.GetCurSel();
	CString sAcctID;
	m_AcctList.GetLBText(index,sAcctID);
	long lAccountID = _wtol(sAcctID);
	BSTR bstrAcctName;
	pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

	//select branch name 
	int index_Branch = m_AreaList.GetCurSel();
	CString sBranchName;
	m_AreaList.GetLBText(index_Branch,sBranchName);
	BSTR bstrBranch = sBranchName.AllocSysString();;

	OutputDebugString(CString(bstrAcctName));
	OutputDebugString(CString(bstrBranch));
	_variant_t vTzs;
	vTzs.Clear();
	int status = pApplication->GetAvailableTimezonesOfBranch(bstrAcctName,bstrBranch,&vTzs);
	CString test;
	test.Format(_T("%d"),status);
	OutputDebugString(test);

	if(vTzs.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		ITimeZone *pTz = NULL;
		
		COleSafeArray sa(vTzs);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_ITimeZone,(void**)&pTz);
			if (pTz != NULL)
			{
				m_Timezones.AddString(pTz->TimeZoneName);
				pTz->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	m_Timezones.SetCurSel(0);
}
void CConfigureAreaAccess::OnSelchangeAcctlist() 
{
	int index_Acct = m_AcctList.GetCurSel();
	CString sAcctid;

	m_AcctList.GetLBText(index_Acct,sAcctid);
	long lAccountID = _wtoi(sAcctid);

	/*m_AcclList.ResetContent();
	LoadAccessLevels();
	m_AreaList.ResetContent();
	m_AreaList.AddString("AccessArea");
	LoadBranchList();
	m_ReadersList.ResetContent();
	m_Timezones.ResetContent();
	m_Readers_TZ.ResetContent();*/

	m_SubAcctList.ResetContent();
	LoadSubAccounts(lAccountID);
		
}

void CConfigureAreaAccess::OnSelchangeSubAcctlist() 
{
	m_AcclList.ResetContent();
	LoadAccessLevels();
	m_AreaList.ResetContent();
	m_AreaList.AddString(L"AccessArea");
	LoadBranchList();
	m_ReadersList.ResetContent();
	m_Timezones.ResetContent();
	m_Readers_TZ.ResetContent();
		
}

void CConfigureAreaAccess::OnSelchangeArealist() 
{
	m_ReadersList.ResetContent();
	m_Readers_TZ.ResetContent();
	LoadReaders();
	m_Timezones.ResetContent();
	LoadAvailBranchTZs();
	
}

void CConfigureAreaAccess::OnConfArea() 
{
		BSTR bstrTzName;	
		//select time zone name 
		int index_Tz = m_Timezones.GetCurSel();
		CString sTZName;
		if (index_Tz <0)
			bstrTzName = SysAllocString(L""); 
		else
		{
			m_Timezones.GetLBText(index_Tz,sTZName);
			bstrTzName = sTZName.AllocSysString();
		}
	
		//select access level 
		BSTR bstrAcclName;
		int index_Accl = m_AcclList.GetCurSel();
		CString sAcclName;
		if (index_Accl <0)
			bstrAcclName = SysAllocString(L"");
		else
		{
			m_AcclList.GetLBText(index_Accl,sAcclName);
			bstrAcclName = sAcclName.AllocSysString();
		}

		int ncount = m_ReadersList.GetCount();
		VARIANT vReader;
		vReader.vt = VT_EMPTY;
		if(ncount >0)
		{
			COleSafeArray saReader;
			saReader.CreateOneDim(VT_BSTR,ncount);

			for(long i = 0 ; i<ncount ; i++)
			{
				CString sReaderName;
				m_ReadersList.GetText(i,sReaderName);
				BSTR bstrReaderName = sReaderName.AllocSysString();
				saReader.PutElement(&i,static_cast<BSTR>(bstrReaderName));
			}
			vReader= saReader.Detach();
		}
		
		//select account name 
		int index = m_AcctList.GetCurSel();
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAccountID = _wtol(sAcctID);
		BSTR bstrAcctName;
		pApplication->GetAccountNameByAcctID(lAccountID,&bstrAcctName);

		//configure the access level 
		long lStatus;
		pApplication->ConfigureAccessLevel(bstrAcclName,bstrAcctName,vReader,bstrTzName,&lStatus);

		if (lStatus == 201)
		{
			AfxMessageBox(L"Invalid access level Name");
			return;
		}
		else if (lStatus == 205)
		{
			AfxMessageBox(L"No Readers");
			return;
		}
		else if (lStatus == 211)
		{
			AfxMessageBox(L"Access Level Overflow for the Panel. Panel already have 128 ALs");
			return;
		}
		else if (lStatus == 1)
		{
			AfxMessageBox(L"Configure Area Access Failed");
			return;
		}
		else
		{
			AfxMessageBox(L"Configure Area Access Succeded");
			CDialog ::OnOK();
		}		
}
